/*****************************************************************

Copyright (c) 1991, 1997 Digital Equipment Corporation, Maynard, Massachusetts.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
DIGITAL EQUIPMENT CORPORATION BE LIABLE FOR ANY CLAIM, DAMAGES, INCLUDING,
BUT NOT LIMITED TO CONSEQUENTIAL OR INCIDENTAL DAMAGES, OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of Digital Equipment Corporation
shall not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from Digital
Equipment Corporation.

******************************************************************/

/* THIS IS NOT AN X PROJECT TEAM SPECIFICATION */

#ifndef _PANORAMIX_H_
#define _PANORAMIX_H_

#include <dix-config.h>

#include <X11/Xmd.h>
#include <X11/extensions/panoramiXproto.h>

#include "include/scrnintstr.h" /* for screenInfo */

#include "gcstruct.h"
#include "dixstruct.h"

/*
 *	PanoramiX definitions
 */

typedef struct _PanoramiXInfo {
    XID id;
} PanoramiXInfo;

typedef struct {
    PanoramiXInfo info[MAXSCREENS];
    RESTYPE type;
    union {
        struct {
            char visibility;
            char class;
            char root;
        } win;
        struct {
            Bool shared;
        } pix;
        struct {
            Bool root;
        } pict;
        char raw_data[4];
    } u;
} PanoramiXRes;

/*
 * macro for looping over all screens (up to `PanoramiXNumScreens`).
 * Makes a new scopes and declares `walkScreenIdx` as the current screen's
 * index number as well as `walkScreen` as poiner to current ScreenRec
 *
 * @param __LAMBDA__ the code to be executed in each iteration step.
 */
#define XINERAMA_FOR_EACH_SCREEN_FORWARD(__LAMBDA__) \
    do { \
        for (unsigned walkScreenIdx = 0; walkScreenIdx < PanoramiXNumScreens; walkScreenIdx++) { \
            ScreenPtr walkScreen = screenInfo.screens[walkScreenIdx]; \
            (void)walkScreen; \
            __LAMBDA__; \
        } \
    } while (0);

/*
 * just like XINERAMA_FOR_EACH_SCREEN_FORWARD(), but skipping the first
 * screen (which is the frontend to the client)
 *
 * @param __LAMBDA__ the code to be executed in each iteration step.
 */
#define XINERAMA_FOR_EACH_SCREEN_FORWARD_SKIP0(__LAMBDA__) \
    do { \
        for (unsigned walkScreenIdx = 1; walkScreenIdx < PanoramiXNumScreens; walkScreenIdx++) { \
            ScreenPtr walkScreen = screenInfo.screens[walkScreenIdx]; \
            (void)walkScreen; \
            __LAMBDA__; \
        } \
    } while (0);

/*
 * like XINERAMA_FOR_EACH_SCREEN_FORWARD(), but traveling backwards.
 *
 * @param __LAMBDA__ the code to be executed in each iteration step.
 */
#define XINERAMA_FOR_EACH_SCREEN_BACKWARD(__LAMBDA__) \
    do { \
        for (unsigned __walkidx = PanoramiXNumScreens; __walkidx > 0; __walkidx--) { \
            unsigned walkScreenIdx = __walkidx - 1; \
            ScreenPtr walkScreen = screenInfo.screens[walkScreenIdx]; \
            (void)walkScreen; \
            __LAMBDA__; \
        } \
    } while (0);

#define FOR_NSCREENS_FORWARD(j) for(j = 0; j < PanoramiXNumScreens; j++)
#define FOR_NSCREENS_FORWARD_SKIP(j) for(j = 1; j < PanoramiXNumScreens; j++)
#define FOR_NSCREENS_BACKWARD(j) for(j = PanoramiXNumScreens - 1; j >= 0; j--)

#define IS_SHARED_PIXMAP(r) (((r)->type == XRT_PIXMAP) && (r)->u.pix.shared)

#define IS_ROOT_DRAWABLE(d) (((d)->type == XRT_WINDOW) && (d)->u.win.root)
#endif                          /* _PANORAMIX_H_ */
