/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.oned;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.elk.alg.common.compaction.oned.CGroup;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.ICompactionAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.core.options.Direction;

public class LongestPathCompaction
implements ICompactionAlgorithm {
    @Override
    public void compact(OneDimensionalCompactor compactor) {
        double minStartPos = Double.POSITIVE_INFINITY;
        for (CNode cNode : compactor.cGraph.cNodes) {
            minStartPos = Math.min(minStartPos, cNode.cGroup.reference.hitbox.x + cNode.cGroupOffset.x);
        }
        LinkedList<CGroup> sinks = Lists.newLinkedList();
        for (CGroup group : compactor.cGraph.cGroups) {
            group.startPos = minStartPos;
            if (group.outDegree != 0) continue;
            sinks.add(group);
        }
        while (!sinks.isEmpty()) {
            CGroup group;
            group = (CGroup)sinks.poll();
            double diff = group.reference.hitbox.x;
            for (CNode node : group.cNodes) {
                double suggestedX = group.startPos + node.cGroupOffset.x;
                node.startPos = !compactor.isLocked(group, compactor.direction) || node.hitbox.x < suggestedX ? suggestedX : node.hitbox.x;
            }
            group.delta += (diff -= group.reference.startPos);
            group.deltaNormalized = compactor.direction == Direction.RIGHT || compactor.direction == Direction.DOWN ? (group.deltaNormalized += diff) : (group.deltaNormalized -= diff);
            for (CNode node : group.cNodes) {
                for (CNode incNode : node.constraints) {
                    double spacing = compactor.direction.isHorizontal() ? compactor.spacingsHandler.getHorizontalSpacing(node, incNode) : compactor.spacingsHandler.getVerticalSpacing(node, incNode);
                    incNode.cGroup.startPos = Math.max(incNode.cGroup.startPos, node.startPos + node.hitbox.width + spacing - incNode.cGroupOffset.x);
                    if (compactor.isLocked(incNode, compactor.direction)) {
                        incNode.cGroup.startPos = Math.max(incNode.cGroup.startPos, incNode.hitbox.x - incNode.cGroupOffset.x);
                    }
                    --incNode.cGroup.outDegree;
                    if (incNode.cGroup.outDegree != 0) continue;
                    sinks.add(incNode.cGroup);
                }
            }
        }
        for (CNode cNode : compactor.cGraph.cNodes) {
            cNode.hitbox.x = cNode.startPos;
        }
    }
}

